<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/db.php';

$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) {
    exit;
}

function sendMessage($chatId, $text, $replyMarkup = null) {
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    if ($replyMarkup) {
        $data['reply_markup'] = $replyMarkup;
    }
    
    file_get_contents(TELEGRAM_API_URL . "sendMessage?" . http_build_query($data));
}

if (isset($update['message'])) {
    $message = $update['message'];
    $chatId = $message['chat']['id'];
    $text = $message['text'] ?? '';
    
    if (strpos($text, '/start') === 0) {
        // Register or update user
        $userId = $message['from']['id'];
        $username = $message['from']['username'] ?? '';
        $firstName = $message['from']['first_name'] ?? '';
        $lastName = $message['from']['last_name'] ?? '';
        
        $stmt = $pdo->prepare("
            INSERT INTO users (telegram_id, username, first_name, last_name) 
            VALUES (?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE 
                username = VALUES(username),
                first_name = VALUES(first_name),
                last_name = VALUES(last_name)
        ");
        $stmt->execute([$userId, $username, $firstName, $lastName]);
        
        // Send welcome message with WebApp button
        $replyMarkup = [
            'inline_keyboard' => [
                [
                    [
                        'text' => '🚀 Open Game Center',
                        'web_app' => ['url' => WEBAPP_URL]
                    ]
                ]
            ]
        ];
        
        sendMessage(
            $chatId,
            "🎮 <b>Welcome to Game Rewards Bot!</b>\n\n" .
            "🔄 Watch ads, play mini games, and earn rewards!\n" .
            "💰 Withdraw your earnings to your wallet!\n\n" .
            "Click the button below to start:",
            json_encode($replyMarkup)
        );
    }
}
?>