<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Telegram Boost API | Rx Hoster</title>
  <style>
    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background-color: #0e0e0e;
      color: #f1f1f1;
      padding: 40px 20px;
      max-width: 900px;
      margin: auto;
    }

    h1, h2 {
      color: #00ffa5;
      border-bottom: 1px solid #00ffa540;
      padding-bottom: 5px;
    }

    .section {
      margin-bottom: 40px;
    }

    pre {
      background: #1e1e1e;
      padding: 12px 16px;
      border-radius: 8px;
      color: #a0ffa0;
      overflow-x: auto;
      font-size: 15px;
      line-height: 1.5;
    }

    .url {
      background: #000;
      padding: 10px 16px;
      display: inline-block;
      color: #00ffa5;
      font-weight: bold;
      font-size: 16px;
      border-radius: 6px;
      margin-top: 10px;
    }

    ul {
      line-height: 1.7;
      margin-left: 20px;
    }

    a {
      color: #00ffa5;
      text-decoration: underline;
    }

    .footer {
      margin-top: 60px;
      text-align: center;
      font-size: 14px;
      color: #777;
    }

    .highlight {
      color: #00ffa5;
      font-weight: bold;
    }

    .back-btn {
      display: inline-block;
      margin-bottom: 20px;
      padding: 8px 14px;
      background-color: #00ffa5;
      color: #000;
      border-radius: 6px;
      text-decoration: none;
      font-weight: bold;
      transition: background 0.3s ease;
    }

    .back-btn:hover {
      background-color: #00cc86;
    }
  </style>
</head>
<body>

  <a href="boost-calculator.php" class="back-btn">← Back</a>

  <h1>📊 Telegram Boost API – Rx Hoster</h1>
  <p>Simple, fast, and reliable API for calculating Telegram boost requirements based on subscriber count and level.</p>

  <div class="section">
    <h2>🔗 API Endpoint</h2>
    <div class="url">https://rxhoster.top/boost-calculator.php</div>
  </div>

  <div class="section">
    <h2>📥 Required Parameters</h2>
    <ul>
      <li><span class="highlight">subscribers</span> — Total Telegram channel subscribers (e.g., 1500)</li>
      <li><span class="highlight">level</span> — Desired boost level (1 to 100)</li>
    </ul>
    <pre>?subscribers=1500&amp;level=10</pre>
  </div>

  <div class="section">
    <h2>✅ Example Response</h2>
    <pre>{
  "status": "success",
  "subscribers": 1500,
  "level": 10,
  "boosts_needed": 12,
  "credit": "API Made By Rx Hoster"
}</pre>
  </div>

  <div class="section">
    <h2>❌ Error Example</h2>
    <pre>{
  "status": "error",
  "message": "Invalid parameters. Use ?subscribers=XXX&amp;level=1-100",
  "credit": "API Made By Rx Hoster"
}</pre>
  </div>

  <div class="section">
    <h2>💻 Code Examples</h2>

    <h3>🔸 JavaScript (Fetch)</h3>
    <pre>fetch("https://rxhoster.top/boost-calculator.php?subscribers=1500&amp;level=10")
  .then(res =&gt; res.json())
  .then(data =&gt; console.log(data));</pre>

    <h3>🔸 PHP (cURL)</h3>
    <pre>$url = "https://rxhoster.top/boost-calculator.php?subscribers=1500&amp;level=10";
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);
$data = json_decode($response, true);
print_r($data);</pre>

    <h3>🔸 Python (Requests)</h3>
    <pre>import requests

url = "https://rxhoster.top/boost-calculator.php?subscribers=1500&amp;level=10"
response = requests.get(url)
data = response.json()
print(data)</pre>
  </div>

  <div class="section">
    <h2>📌 Notes</h2>
    <ul>
      <li>No API key required currently (public).</li>
      <li>JSON format is returned instantly.</li>
      <li>You can use this API in bots, websites, or mobile apps.</li>
    </ul>
  </div>

  <div class="section">
    <h2>📬 Contact</h2>
    <p>Created by <strong>Rx Hoster</strong> — Telegram: <a href="https://t.me/yourusername" target="_blank">@yourusername</a></p>
  </div>

  <div class="footer">
    &copy; 2025 Rx Hoster — All Rights Reserved
  </div>

</body>
</html>
