<?php
// Bot token and constants
$token = "8126218337:AAGH6VCsyqUJ_4vj0NdRTcrvMqbHtlcrowk";
define('USER_FILE', 'users.json');
define('ORDER_FILE', 'orders.json');
define('DEPOSIT_FILE', 'deposits.json');
define('BOOST_PRICE', 0.32);
define('ADMIN_ID', 6121950277);
define('ORDERS_PER_PAGE', 5);
define('DEPOSITS_PER_PAGE', 5);
define('MIN_DEPOSIT', 1.00);
define('BINANCE_ID', '576051664');
define('BINANCE_QR', 'https://i.postimg.cc/02gqjVbz/IMG-20250708-174537.png');

// Load and save JSON helper functions
function loadJson($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) : [];
}
function saveJson($file, $data) {
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));
}

// Telegram API helpers
function sendMessage($chat_id, $text, $token, $reply_markup = null, $disable_preview = false) {
    $url = "https://api.telegram.org/bot$token/sendMessage";
    $post_fields = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => $disable_preview
    ];
    if ($reply_markup) $post_fields['reply_markup'] = json_encode($reply_markup);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function editMessageText($chat_id, $message_id, $text, $token, $reply_markup = null) {
    $url = "https://api.telegram.org/bot$token/editMessageText";
    $post_fields = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    if ($reply_markup) $post_fields['reply_markup'] = json_encode($reply_markup);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function deleteMessage($chat_id, $message_id, $token) {
    $url = "https://api.telegram.org/bot$token/deleteMessage";
    $post_fields = ['chat_id' => $chat_id, 'message_id' => $message_id];
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function sendPhoto($chat_id, $photo_url, $caption, $token, $reply_markup = null) {
    $url = "https://api.telegram.org/bot$token/sendPhoto";
    $post_fields = [
        'chat_id' => $chat_id,
        'photo' => $photo_url,
        'caption' => $caption,
        'parse_mode' => 'HTML'
    ];
    if ($reply_markup) $post_fields['reply_markup'] = json_encode($reply_markup);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

// Build paginated orders page
function buildOrdersPage($user_id, $page, $orders, $users) {
    $totalOrders = count($orders);
    $totalPages = max(1, ceil($totalOrders / ORDERS_PER_PAGE));
    if ($page < 1) $page = 1;
    if ($page > $totalPages) $page = $totalPages;

    $start = ($page - 1) * ORDERS_PER_PAGE;
    $pageOrders = array_slice($orders, $start, ORDERS_PER_PAGE);

    $userBalance = number_format($users[$user_id]['balance'], 2);
    $userIdText = htmlspecialchars($user_id);

    $text = "👤 <b>User Info</b>\n";
    $text .= "🆔 Telegram ID: <code>$userIdText</code>\n";
    $text .= "💰 Balance: <b>\$$userBalance</b>\n\n";

    $text .= "📦 <b>Your Orders (Page $page of $totalPages):</b>\n\n";

    if (empty($pageOrders)) {
        $text .= "❌ <i>No orders placed yet.</i>";
    } else {
        foreach ($pageOrders as $idx => $order) {
            $num = $start + $idx + 1;
            $price = number_format($order['price'], 2);
            $linkText = "🔗 <a href=\"" . htmlspecialchars($order['link']) . "\">Link</a>";

            $text .= "🔹 <b>Order #$num</b>\n";
            $text .= "   🆔 Order ID: <code>{$order['order_id']}</code>\n";
            $text .= "   📈 Boosts: <b>{$order['amount']}</b>\n";
            $text .= "   💵 Price: <b>\$$price</b>\n";
            $text .= "   $linkText\n\n";
        }
    }

    // Inline keyboard buttons for pagination
    $keyboard = ['inline_keyboard' => []];
    $buttons = [];

    if ($page > 1) {
        $buttons[] = ['text' => '⬅️ Back', 'callback_data' => "orders_page_" . ($page - 1)];
    }
    if ($page < $totalPages) {
        $buttons[] = ['text' => 'Next ➡️', 'callback_data' => "orders_page_" . ($page + 1)];
    }
    if (!empty($buttons)) {
        $keyboard['inline_keyboard'][] = $buttons;
    } else {
        $keyboard = null; // No buttons if only one page
    }

    return [$text, $keyboard];
}

// Build paginated deposits page
function buildDepositsPage($user_id, $page, $deposits, $users) {
    $userDeposits = array_filter($deposits, fn($d) => ($d['user_id'] ?? 0) == $user_id);
    $totalDeposits = count($userDeposits);
    $totalPages = max(1, ceil($totalDeposits / DEPOSITS_PER_PAGE));
    if ($page < 1) $page = 1;
    if ($page > $totalPages) $page = $totalPages;

    $start = ($page - 1) * DEPOSITS_PER_PAGE;
    $pageDeposits = array_slice($userDeposits, $start, DEPOSITS_PER_PAGE);

    $userBalance = number_format($users[$user_id]['balance'], 2);
    $userIdText = htmlspecialchars($user_id);

    $text = "👤 <b>User Info</b>\n";
    $text .= "🆔 Telegram ID: <code>$userIdText</code>\n";
    $text .= "💰 Balance: <b>\$$userBalance</b>\n\n";

    $text .= "💳 <b>Your Deposits (Page $page of $totalPages):</b>\n\n";

    if (empty($pageDeposits)) {
        $text .= "❌ <i>No deposits made yet.</i>";
    } else {
        foreach ($pageDeposits as $idx => $deposit) {
            $num = $start + $idx + 1;
            $amount = number_format($deposit['amount'], 2);
            $status = $deposit['status'] == 'completed' ? '✅ Completed' : ($deposit['status'] == 'rejected' ? '❌ Rejected' : '⏳ Pending');
            $date = date('Y-m-d H:i', $deposit['timestamp']);

            $text .= "🔹 <b>Deposit #$num</b>\n";
            $text .= "   🆔 ID: <code>{$deposit['deposit_id']}</code>\n";
            $text .= "   💰 Amount: <b>\$$amount</b>\n";
            $text .= "   📅 Date: $date\n";
            $text .= "   📌 Status: $status\n\n";
        }
    }

    // Inline keyboard buttons for pagination
    $keyboard = ['inline_keyboard' => []];
    $buttons = [];

    if ($page > 1) {
        $buttons[] = ['text' => '⬅️ Back', 'callback_data' => "deposits_page_" . ($page - 1)];
    }
    if ($page < $totalPages) {
        $buttons[] = ['text' => 'Next ➡️', 'callback_data' => "deposits_page_" . ($page + 1)];
    }
    
    // Add back to account button
    $buttons[] = ['text' => '🔙 Account', 'callback_data' => "back_to_account"];
    
    if (!empty($buttons)) {
        $keyboard['inline_keyboard'][] = $buttons;
    } else {
        $keyboard = null; // No buttons if only one page
    }

    return [$text, $keyboard];
}

// Load data
$users = loadJson(USER_FILE);
$orders = loadJson(ORDER_FILE);
$deposits = loadJson(DEPOSIT_FILE);

// Input update
$update = json_decode(file_get_contents('php://input'), true);

// Handle messages
if (isset($update['message'])) {
    $msg = $update['message'];
    $chat_id = $msg['chat']['id'];
    $text = trim($msg['text'] ?? '');
    $photo = $msg['photo'] ?? null;

    // Register user if not exists
    if (!isset($users[$chat_id])) {
        $users[$chat_id] = ['balance' => 0.00];
        saveJson(USER_FILE, $users);
    }

    // Admin: Add balance command
    if (strpos($text, '/addbalance') === 0) {
        if ($chat_id != ADMIN_ID) {
            sendMessage($chat_id, "❌ You are not authorized to use this command.", $token, null, true);
            exit;
        }
        $parts = explode(' ', $text);
        if (count($parts) !== 3) {
            sendMessage($chat_id, "⚠️ Usage: /addbalance <user_chat_id> <amount>", $token, null, true);
            exit;
        }
        $user_id = $parts[1];
        $amount = floatval($parts[2]);
        if ($amount <= 0) {
            sendMessage($chat_id, "⚠️ Amount must be greater than zero.", $token, null, true);
            exit;
        }
        if (!isset($users[$user_id])) $users[$user_id] = ['balance' => 0.00];
        $users[$user_id]['balance'] += $amount;
        saveJson(USER_FILE, $users);
        sendMessage($chat_id, "✅ Added \$$amount to user <b>$user_id</b> balance.", $token, null, true);
        sendMessage($user_id, "🎉 Your balance has been increased by <b>\$$amount</b> by admin!", $token, null, true);
        exit;
    }

    // /start command (updated with deposit info)
    if ($text === "/start") {
        $reply = "👋 <b>Welcome to the Boost & Calculator Bot!</b>\n\n"
               . "🧮 Use the <code>/boost</code> command to calculate how many boosts you need.\n"
               . "🔎 Format: <code>/boost [subscribers] [level]</code>\n"
               . "Example: <code>/boost 1500 8</code>\n\n"
               . "📦 Use <code>/order</code> to buy real Telegram channel boosts.\n"
               . "💳 Check your balance and orders using <code>/account</code>\n"
               . "💰 Add funds to your account with <code>/deposit</code>\n"
               . "📋 View your deposit history with <code>/deposits</code>\n\n"
               . "🚀 <b>Minimum Boost Order:</b> <code>10</code>\n"
               . "💰 <b>Per Boost Price:</b> <code>$0.32</code>\n"
               . "💵 <b>Minimum Deposit:</b> <code>$1.00</code>\n\n"
               . "📞 If you need help, contact admin.";
        sendMessage($chat_id, $reply, $token, null, true);
        exit;
    }

    // /deposits command - show deposit history page 1
    if ($text === "/deposits") {
        list($text, $keyboard) = buildDepositsPage($chat_id, 1, $deposits, $users);
        sendMessage($chat_id, $text, $token, $keyboard, true);
        exit;
    }

    // /deposit command
    if ($text === "/deposit") {
        $users[$chat_id]['step'] = 'await_deposit_amount';
        saveJson(USER_FILE, $users);
        sendMessage($chat_id, "💰 <b>Deposit Funds</b>\n\nHow much would you like to deposit?\nMinimum amount: <b>\$" . MIN_DEPOSIT . "</b>", $token, null, true);
        exit;
    }

    // Handle deposit amount input
    if (isset($users[$chat_id]['step']) && $users[$chat_id]['step'] === 'await_deposit_amount') {
        if (!is_numeric($text) || floatval($text) < MIN_DEPOSIT) {
            sendMessage($chat_id, "⚠️ Please enter a valid amount (minimum \$" . MIN_DEPOSIT . ").", $token, null, true);
            exit;
        }
        
        $amount = round(floatval($text), 2);
        $users[$chat_id]['temp_deposit'] = ['amount' => $amount];
        $users[$chat_id]['step'] = 'await_deposit_confirm';
        saveJson(USER_FILE, $users);
        
        $caption = "💰 <b>Deposit \$" . number_format($amount, 2) . "</b>\n\n"
                 . "🔹 Binance ID: <code>" . BINANCE_ID . "</code>\n"
                 . "🔹 Scan QR code or send manually\n\n"
                 . "After payment, click Complete below and follow instructions.";
                 
        $keyboard = [
            'inline_keyboard' => [
                [['text' => '✅ Complete Payment', 'callback_data' => 'deposit_complete']],
                [['text' => '❌ Cancel Deposit', 'callback_data' => 'deposit_cancel']]
            ]
        ];
        
        sendPhoto($chat_id, BINANCE_QR, $caption, $token, $keyboard);
        exit;
    }

    // Handle deposit screenshot upload
    if (isset($users[$chat_id]['step']) && $users[$chat_id]['step'] === 'await_deposit_screenshot' && $photo) {
        $file_id = $photo[count($photo)-1]['file_id']; // Get highest resolution photo
        $users[$chat_id]['temp_deposit']['screenshot'] = $file_id;
        $users[$chat_id]['step'] = 'await_deposit_order_id';
        saveJson(USER_FILE, $users);
        
        sendMessage($chat_id, "📸 Screenshot received. Now please send your Binance Order ID:", $token, null, true);
        exit;
    }

    // Handle deposit order ID input
    if (isset($users[$chat_id]['step']) && $users[$chat_id]['step'] === 'await_deposit_order_id') {
        $order_id = trim($text);
        if (empty($order_id)) {
            sendMessage($chat_id, "⚠️ Please enter a valid Binance Order ID.", $token, null, true);
            exit;
        }
        
        $users[$chat_id]['temp_deposit']['order_id'] = $order_id;
        $users[$chat_id]['step'] = 'deposit_completed';
        saveJson(USER_FILE, $users);
        
        // Create deposit record
        $deposit_id = time();
        $deposits[$deposit_id] = [
            'deposit_id' => $deposit_id,
            'user_id' => $chat_id,
            'amount' => $users[$chat_id]['temp_deposit']['amount'],
            'screenshot' => $users[$chat_id]['temp_deposit']['screenshot'],
            'order_id' => $order_id,
            'timestamp' => time(),
            'status' => 'pending'
        ];
        saveJson(DEPOSIT_FILE, $deposits);
        
        // Notify admin
        $admin_msg = "📢 <b>New Deposit Request</b>\n\n"
                   . "👤 User: <code>$chat_id</code>\n"
                   . "💰 Amount: <b>\$" . number_format($users[$chat_id]['temp_deposit']['amount'], 2) . "</b>\n"
                   . "🆔 Order ID: <code>$order_id</code>\n\n"
                   . "⏳ Please review this deposit.";
                   
        $admin_keyboard = [
            'inline_keyboard' => [
                [['text' => '✅ Approve Deposit', 'callback_data' => "deposit_approve_$deposit_id"]],
                [['text' => '❌ Reject Deposit', 'callback_data' => "deposit_reject_$deposit_id"]]
            ]
        ];
        
        sendMessage(ADMIN_ID, $admin_msg, $token, $admin_keyboard, true);
        
        // Confirm to user
        sendMessage($chat_id, "✅ Your deposit request has been submitted!\n\nAmount: <b>\$" . number_format($users[$chat_id]['temp_deposit']['amount'], 2) . "</b>\nOrder ID: <code>$order_id</code>\n\nYour balance will be updated within 1-24 hours after admin review.", $token, null, true);
        
        // Clean up
        unset($users[$chat_id]['temp_deposit'], $users[$chat_id]['step']);
        saveJson(USER_FILE, $users);
        exit;
    }

    // /boost command
    if (preg_match('/^\/boost\s+(\d+)\s+(\d+)$/i', $text, $matches)) {
        $subscribers = intval($matches[1]);
        $level = intval($matches[2]);

        // Call your external API
        $api_url = "https://rxhoster.top/test.php?subscribers=$subscribers&level=$level";

        $api_response = file_get_contents($api_url);
        if ($api_response === false) {
            sendMessage($chat_id, "⚠️ <b>Error:</b> Could not reach the API. Please try again later.", $token, null, true);
            exit;
        }

        $data = json_decode($api_response, true);
        if (!$data || !isset($data['status']) || $data['status'] !== 'success') {
            sendMessage($chat_id, "⚠️ <b>Error:</b> Invalid API response.", $token, null, true);
            exit;
        }

        // Build formatted boost message
        $msg = "🔥 <b>Boost Calculation Result</b> 🔥\n\n"
             . "👥 <b>Subscribers:</b> {$data['subscribers']}\n"
             . "📈 <b>Current Level:</b> {$data['level']}\n"
             . "⚡ <b>Boosts Needed:</b> {$data['boosts_needed']}\n\n"
             . "💬 <i>{$data['message']}</i>\n\n"
             . "🔰 <i>{$data['credit']}</i>";

        sendMessage($chat_id, $msg, $token, null, true);
        exit;
    }

    // /account command - show account summary
    if ($text === "/account") {
        $userOrders = array_filter($orders, fn($o) => ($o['user_id'] ?? 0) == $chat_id);
        $userDeposits = array_filter($deposits, fn($d) => ($d['user_id'] ?? 0) == $chat_id);
        
        $userBalance = number_format($users[$chat_id]['balance'], 2);
        $userIdText = htmlspecialchars($chat_id);

        $text = "👤 <b>Account Summary</b>\n";
        $text .= "🆔 Telegram ID: <code>$userIdText</code>\n";
        $text .= "💰 Balance: <b>\$$userBalance</b>\n\n";

        // Orders summary
        $totalOrders = count($userOrders);
        $text .= "📦 <b>Orders:</b> $totalOrders\n";
        
        // Deposits summary
        $completedDeposits = array_filter($userDeposits, fn($d) => $d['status'] == 'completed');
        $pendingDeposits = array_filter($userDeposits, fn($d) => $d['status'] == 'pending');
        $rejectedDeposits = array_filter($userDeposits, fn($d) => $d['status'] == 'rejected');
        
        $text .= "💳 <b>Deposits:</b>\n";
        $text .= "   ✅ Completed: " . count($completedDeposits) . "\n";
        $text .= "   ⏳ Pending: " . count($pendingDeposits) . "\n";
        $text .= "   ❌ Rejected: " . count($rejectedDeposits) . "\n\n";
        
        $text .= "Use commands:\n";
        $text .= "/orders - View your order history\n";
        $text .= "/deposits - View your deposit history";

        $keyboard = [
            'inline_keyboard' => [
                [['text' => '📦 View Orders', 'callback_data' => 'view_orders_1']],
                [['text' => '💳 View Deposits', 'callback_data' => 'view_deposits_1']]
            ]
        ];

        sendMessage($chat_id, $text, $token, $keyboard, true);
        exit;
    }

    // /orders command - show orders page 1
    if ($text === "/orders") {
        $userOrders = array_filter($orders, fn($o) => ($o['user_id'] ?? 0) == $chat_id);
        usort($userOrders, fn($a, $b) => $b['order_id'] <=> $a['order_id']); // newest first
        list($text, $keyboard) = buildOrdersPage($chat_id, 1, $userOrders, $users);
        sendMessage($chat_id, $text, $token, $keyboard, true);
        exit;
    }

    // /order command: start order flow
    if ($text === "/order") {
        $users[$chat_id]['step'] = 'await_amount';
        saveJson(USER_FILE, $users);
        sendMessage($chat_id, "📌 How many boosts do you want to buy?\nMinimum: <b>10</b>", $token, null, true);
        exit;
    }

    // Handle order flow steps
    if (isset($users[$chat_id]['step'])) {
        $step = $users[$chat_id]['step'];

        if ($step === 'await_amount') {
            if (!is_numeric($text) || intval($text) < 10) {
                sendMessage($chat_id, "⚠️ Please enter a valid number of boosts (minimum 10).", $token, null, true);
                exit;
            }
            $amount = intval($text);
            $price = $amount * BOOST_PRICE;
            $users[$chat_id]['temp_order'] = ['amount' => $amount, 'price' => $price];
            $users[$chat_id]['step'] = 'await_link';
            saveJson(USER_FILE, $users);
            sendMessage($chat_id, "💸 Total price for <b>$amount</b> boosts is <b>\$$price</b>.\n\nSend your channel boost link (must start with <code>https://t.me/</code>)", $token, null, true);
            exit;
        }

        if ($step === 'await_link') {
            if (strpos($text, 'https://t.me/') !== 0) {
                sendMessage($chat_id, "❌ Invalid link! Please send a link starting with <code>https://t.me/</code>", $token, null, true);
                exit;
            }
            $users[$chat_id]['temp_order']['link'] = $text;
            $users[$chat_id]['step'] = 'confirm_order';
            saveJson(USER_FILE, $users);

            $order = $users[$chat_id]['temp_order'];
            $msg = "✅ <b>Confirm Your Order</b>\n\n"
                . "Boosts: <b>{$order['amount']}</b>\n"
                . "Price: <b>\${$order['price']}</b>\n"
                . "Link: {$order['link']}\n\nPlease confirm or cancel your order.";

            $keyboard = [
                'inline_keyboard' => [
                    [['text' => '✅ Confirm', 'callback_data' => 'confirm']],
                    [['text' => '❌ Cancel', 'callback_data' => 'cancel']]
                ]
            ];
            sendMessage($chat_id, $msg, $token, $keyboard, true);
            exit;
        }
    }

    // Unknown command fallback
    sendMessage($chat_id, "❓ Unknown command.\nUse /start for help.", $token, null, true);
    exit;
}

// Handle callback queries
if (isset($update['callback_query'])) {
    $cb = $update['callback_query'];
    $from_id = $cb['from']['id'];
    $data = $cb['data'];
    $msg_id = $cb['message']['message_id'];
    $chat_id = $cb['message']['chat']['id'];

    // Pagination for orders
    if (preg_match('/^orders_page_(\d+)$/', $data, $matches) || preg_match('/^view_orders_(\d+)$/', $data, $matches)) {
        $page = intval($matches[1]);
        $userOrders = array_filter($orders, fn($o) => ($o['user_id'] ?? 0) == $from_id);
        usort($userOrders, fn($a, $b) => $b['order_id'] <=> $a['order_id']); // newest first
        list($text, $keyboard) = buildOrdersPage($from_id, $page, $userOrders, $users);
        editMessageText($chat_id, $msg_id, $text, $token, $keyboard);
        exit;
    }

    // Pagination for deposits
    if (preg_match('/^deposits_page_(\d+)$/', $data, $matches) || preg_match('/^view_deposits_(\d+)$/', $data, $matches)) {
        $page = intval($matches[1]);
        list($text, $keyboard) = buildDepositsPage($from_id, $page, $deposits, $users);
        editMessageText($chat_id, $msg_id, $text, $token, $keyboard);
        exit;
    }

    // Back to account
    if ($data === 'back_to_account') {
        $userOrders = array_filter($orders, fn($o) => ($o['user_id'] ?? 0) == $from_id);
        $userDeposits = array_filter($deposits, fn($d) => ($d['user_id'] ?? 0) == $from_id);
        
        $userBalance = number_format($users[$from_id]['balance'], 2);
        $userIdText = htmlspecialchars($from_id);

        $text = "👤 <b>Account Summary</b>\n";
        $text .= "🆔 Telegram ID: <code>$userIdText</code>\n";
        $text .= "💰 Balance: <b>\$$userBalance</b>\n\n";

        // Orders summary
        $totalOrders = count($userOrders);
        $text .= "📦 <b>Orders:</b> $totalOrders\n";
        
        // Deposits summary
        $completedDeposits = array_filter($userDeposits, fn($d) => $d['status'] == 'completed');
        $pendingDeposits = array_filter($userDeposits, fn($d) => $d['status'] == 'pending');
        $rejectedDeposits = array_filter($userDeposits, fn($d) => $d['status'] == 'rejected');
        
        $text .= "💳 <b>Deposits:</b>\n";
        $text .= "   ✅ Completed: " . count($completedDeposits) . "\n";
        $text .= "   ⏳ Pending: " . count($pendingDeposits) . "\n";
        $text .= "   ❌ Rejected: " . count($rejectedDeposits) . "\n\n";
        
        $text .= "Use commands:\n";
        $text .= "/orders - View your order history\n";
        $text .= "/deposits - View your deposit history";

        $keyboard = [
            'inline_keyboard' => [
                [['text' => '📦 View Orders', 'callback_data' => 'view_orders_1']],
                [['text' => '💳 View Deposits', 'callback_data' => 'view_deposits_1']]
            ]
        ];

        editMessageText($chat_id, $msg_id, $text, $token, $keyboard);
        exit;
    }

    // Cancel deposit
    if ($data === 'deposit_cancel') {
        deleteMessage($chat_id, $msg_id, $token);
        if (isset($users[$from_id]['temp_deposit'])) unset($users[$from_id]['temp_deposit']);
        if (isset($users[$from_id]['step'])) unset($users[$from_id]['step']);
        saveJson(USER_FILE, $users);
        sendMessage($chat_id, "❌ Deposit cancelled.", $token, null, true);
        exit;
    }

    // Complete deposit - request screenshot
    if ($data === 'deposit_complete') {
        deleteMessage($chat_id, $msg_id, $token);
        if (!isset($users[$from_id]['temp_deposit'])) {
            sendMessage($chat_id, "⚠️ No active deposit found.", $token, null, true);
            exit;
        }
        
        $users[$from_id]['step'] = 'await_deposit_screenshot';
        saveJson(USER_FILE, $users);
        sendMessage($chat_id, "📸 Please send a screenshot of your Binance payment as a photo (not file).", $token, null, true);
        exit;
    }

    // Admin: Approve deposit
    if (strpos($data, 'deposit_approve_') === 0) {
        if ($from_id != ADMIN_ID) {
            sendMessage($chat_id, "❌ You are not authorized to approve deposits.", $token, null, true);
            exit;
        }
        
        $deposit_id = str_replace('deposit_approve_', '', $data);
        if (!isset($deposits[$deposit_id])) {
            sendMessage($chat_id, "⚠️ Deposit not found.", $token, null, true);
            exit;
        }
        
        // Update deposit status
        $deposits[$deposit_id]['status'] = 'completed';
        $deposits[$deposit_id]['processed_by'] = ADMIN_ID;
        $deposits[$deposit_id]['processed_at'] = time();
        
        // Add balance to user
        $user_id = $deposits[$deposit_id]['user_id'];
        $amount = $deposits[$deposit_id]['amount'];
        
        if (!isset($users[$user_id])) $users[$user_id] = ['balance' => 0.00];
        $users[$user_id]['balance'] += $amount;
        
        // Save changes
        saveJson(DEPOSIT_FILE, $deposits);
        saveJson(USER_FILE, $users);
        
        // Notify user
        sendMessage($user_id, "🎉 Your deposit of <b>\$" . number_format($amount, 2) . "</b> has been approved!\n\nYour new balance: <b>\$" . number_format($users[$user_id]['balance'], 2) . "</b>", $token, null, true);
        
        // Update admin message
        $admin_msg = "✅ <b>Deposit Approved</b>\n\n"
                   . "👤 User: <code>$user_id</code>\n"
                   . "💰 Amount: <b>\$" . number_format($amount, 2) . "</b>\n"
                   . "🆔 Order ID: <code>{$deposits[$deposit_id]['order_id']}</code>\n"
                   . "📅 Approved at: " . date('Y-m-d H:i');
        
        editMessageText($chat_id, $msg_id, $admin_msg, $token);
        exit;
    }

    // Admin: Reject deposit
    if (strpos($data, 'deposit_reject_') === 0) {
        if ($from_id != ADMIN_ID) {
            sendMessage($chat_id, "❌ You are not authorized to reject deposits.", $token, null, true);
            exit;
        }
        
        $deposit_id = str_replace('deposit_reject_', '', $data);
        if (!isset($deposits[$deposit_id])) {
            sendMessage($chat_id, "⚠️ Deposit not found.", $token, null, true);
            exit;
        }
        
        // Update deposit status
        $deposits[$deposit_id]['status'] = 'rejected';
        $deposits[$deposit_id]['processed_by'] = ADMIN_ID;
        $deposits[$deposit_id]['processed_at'] = time();
        saveJson(DEPOSIT_FILE, $deposits);
        
        // Ask admin for rejection reason
        $users[ADMIN_ID]['step'] = 'await_reject_reason';
        $users[ADMIN_ID]['temp_deposit_id'] = $deposit_id;
        saveJson(USER_FILE, $users);
        
        sendMessage($chat_id, "📝 Please enter the reason for rejecting this deposit:", $token, null, true);
        exit;
    }

    // Cancel order
    if ($data === 'cancel') {
        deleteMessage($chat_id, $msg_id, $token);
        if (isset($users[$from_id]['temp_order'])) unset($users[$from_id]['temp_order']);
        if (isset($users[$from_id]['step'])) unset($users[$from_id]['step']);
        saveJson(USER_FILE, $users);
        sendMessage($chat_id, "❌ Order cancelled.", $token, null, true);
        exit;
    }

    // Confirm order
    if ($data === 'confirm') {
        if (!isset($users[$from_id]['temp_order'])) {
            deleteMessage($chat_id, $msg_id, $token);
            sendMessage($chat_id, "⚠️ No active order found.", $token, null, true);
            exit;
        }
        $order = $users[$from_id]['temp_order'];
        $bal = $users[$from_id]['balance'];

        if ($bal < $order['price']) {
            deleteMessage($chat_id, $msg_id, $token);
            unset($users[$from_id]['temp_order'], $users[$from_id]['step']);
            saveJson(USER_FILE, $users);
            sendMessage($chat_id, "⚠️ Insufficient balance! You need \${$order['price']} to place this order.", $token, null, true);
            exit;
        }

        $users[$from_id]['balance'] -= $order['price'];

        // API call
        $api_url = "https://smmgen.com/api/v2";
        $post_data = [
            'key' => 'b7167959609f20c25677f540c521eb96',
            'action' => 'add',
            'service' => '12340',
            'link' => $order['link'],
            'quantity' => $order['amount']
        ];
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        $api_res = curl_exec($ch);
        curl_close($ch);

        $api_data = json_decode($api_res, true);

        if (isset($api_data['order'])) {
            $order_id = $api_data['order'];
            // Save order
            $orders[] = [
                'user_id' => $from_id,
                'order_id' => $order_id,
                'amount' => $order['amount'],
                'price' => $order['price'],
                'link' => $order['link'],
                'timestamp' => time()
            ];
            saveJson(ORDER_FILE, $orders);
            saveJson(USER_FILE, $users);
            deleteMessage($chat_id, $msg_id, $token);
            unset($users[$from_id]['temp_order'], $users[$from_id]['step']);
            saveJson(USER_FILE, $users);
            sendMessage($chat_id,
                "🎉 Your order was successfully placed!\n"
                . "🆔 Order ID: <code>$order_id</code>\n"
                . "📦 Boosts: {$order['amount']}\n\n"
                . "⏳ Your channel will be boosted soon.", $token, null, true);
            sendMessage(ADMIN_ID,
                "📢 New order placed!\nUser: <code>$from_id</code>\nOrder ID: <code>$order_id</code>\nBoosts: {$order['amount']}\nPrice: \${$order['price']}", $token, null, true);
            exit;
        } else {
            deleteMessage($chat_id, $msg_id, $token);
            unset($users[$from_id]['temp_order'], $users[$from_id]['step']);
            saveJson(USER_FILE, $users);
            sendMessage($chat_id, "⚠️ Error placing order: Please contact admin.", $token, null, true);
            sendMessage(ADMIN_ID, "⚠️ API error placing order for user $from_id:\n" . $api_res, $token, null, true);
            exit;
        }
    }
}

// Handle admin rejection reason
if (isset($update['message']) && isset($users[$update['message']['chat']['id']]['step']) && $users[$update['message']['chat']['id']]['step'] === 'await_reject_reason') {
    $msg = $update['message'];
    $chat_id = $msg['chat']['id'];
    $text = trim($msg['text'] ?? '');
    
    if ($chat_id != ADMIN_ID) {
        exit;
    }
    
    if (empty($text)) {
        sendMessage($chat_id, "⚠️ Please enter a valid rejection reason.", $token, null, true);
        exit;
    }
    
    $deposit_id = $users[ADMIN_ID]['temp_deposit_id'];
    $deposit = $deposits[$deposit_id];
    $user_id = $deposit['user_id'];
    
    // Clean up admin state
    unset($users[ADMIN_ID]['step'], $users[ADMIN_ID]['temp_deposit_id']);
    saveJson(USER_FILE, $users);
    
    // Notify user
    sendMessage($user_id, "❌ Your deposit of <b>\$" . number_format($deposit['amount'], 2) . "</b> was rejected.\n\nReason: <i>$text</i>", $token, null, true);
    
    // Update admin message
    $admin_msg = "❌ <b>Deposit Rejected</b>\n\n"
               . "👤 User: <code>$user_id</code>\n"
               . "💰 Amount: <b>\$" . number_format($deposit['amount'], 2) . "</b>\n"
               . "🆔 Order ID: <code>{$deposit['order_id']}</code>\n"
               . "📅 Rejected at: " . date('Y-m-d H:i') . "\n"
               . "📝 Reason: <i>$text</i>";
    
    sendMessage($chat_id, $admin_msg, $token, null, true);
    exit;
}

// If nothing matched, exit silently
exit;
?>